set more off
global path_in ""
global path_temp ""
global path_out ""

* Store within-industry predictions from Table 9

**1. Preparing data: merging time-averaged up- and downstream weights into EUKLEMS data, calculate net aggregate up- and down-stream productivity growth
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Generate industry variable consistent with coding in IO weights file
	gen 	industry=1	if	code=="C"
	replace industry=2	if	code=="15t16"
	replace industry=3	if	code=="17t19"
	replace industry=4	if	code=="20"
	replace industry=5	if	code=="21t22"
	replace industry=6	if	code=="23"
	replace industry=7	if	code=="24"
	replace industry=8	if	code=="25"
	replace industry=9	if	code=="26"
	replace industry=10	if	code=="27t28"
	replace industry=11	if	code=="29"
	replace industry=12	if	code=="30t33"
	replace industry=13	if	code=="34t35"
	replace industry=14	if	code=="36t37"
	replace industry=15	if	code=="E"
	replace industry=16	if	code=="F"
	replace industry=17	if	code=="50"
	replace industry=18	if	code=="51"
	replace industry=19	if	code=="52"
	replace industry=20	if	code=="H"
	replace industry=21	if	code=="60t63"
	replace industry=22	if	code=="64"
	replace industry=23	if	code=="J"
	replace industry=24	if	code=="70"
	replace industry=25	if	code=="71t74"
	replace industry=26	if	code=="M"
	replace industry=27	if	code=="N"
	replace industry=28	if	code=="O"

	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP

	*Reshape to obtain TFP in wide form, to multiply with weights later on
	preserve
	keep country industry year D1_LP1_EMP
	reshape wide D1_LP1_EMP, i(country year) j(industry)
	save $path_temp\temp_TFPwide, replace
	restore
	
	*Merging in IO weights
	merge m:1 country industry using $path_in\IO_weights
	keep if _==3 /*all KLEMS countries are matched*/
	drop _ 
	
	*Merging in wide TFP
	merge m:1 country year using $path_temp\temp_TFPwide
	drop _ /*100% matched*/
	
	*Calculate country-level mean productivity growth among supplier (upstream) industries
	forvalues industry = 1(1)28 {
		gen D1_LP1_EMP_up`industry'=D1_LP1_EMP`industry'*w_up_`industry'
	}
	egen D1_LP1_EMP_net_up=rowtotal(D1_LP1_EMP_up*), missing
	label var D1_LP1_EMP_net_up "Aggregate productivity growth in upstream industries by industry-country-year"
	drop D1_LP1_EMP_up* w_up*
	
	*Calculate country-level mean productivity growth among customer (downstream) industries
	forvalues industry = 1(1)28 {
		gen D1_LP1_EMP_down`industry'=D1_LP1_EMP`industry'*w_down_`industry'
	}
	egen D1_LP1_EMP_net_down=rowtotal(D1_LP1_EMP_down*), missing
	label var D1_LP1_EMP_net_down "Aggregate productivity growth in downstream industries by industry-country-year"
	drop D1_LP1_EMP_down* w_down* 
	forvalues industry = 1(1)28 {
		drop D1_LP1_EMP`industry'
	}
	
	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
	
	*Rename up/down as supplier & customer
	rename D1_LP1_EMP_net_up D1_LP1_EMP_net_sup
	rename D1_LP1_EMP_net_down D1_LP1_EMP_net_cus
	label var D1_LP1_EMP_net_sup "Supplier TFP growth"
	label var D1_LP1_EMP_net_cus "Customer TFP growth"

	*Standardize TFP terms
	drop if D1_LP1_EMP==.
	foreach var in D1_LP1_EMP  D1_LP1_EMP_net_cus D1_LP1_EMP_net_sup {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
save $path_temp\temp1, replace


**2. Estimate Table 9, store estimates, calculate predictions
use $path_temp\temp1, clear
	
	tsset cross year
	
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP "
	local sup 		"D1_LP1_EMP_net_sup L.D1_LP1_EMP_net_sup L2.D1_LP1_EMP_net_sup L3.D1_LP1_EMP_net_sup L4.D1_LP1_EMP_net_sup L5.D1_LP1_EMP_net_sup"
	local cus 		"D1_LP1_EMP_net_cus L.D1_LP1_EMP_net_cus L2.D1_LP1_EMP_net_cus L3.D1_LP1_EMP_net_cus L4.D1_LP1_EMP_net_cus L5.D1_LP1_EMP_net_cus"
	local aggR		"D1_lnVA_QI_LO L.D1_lnVA_QI_LO L2.D1_lnVA_QI_LO L3.D1_lnVA_QI_LO L4.D1_lnVA_QI_LO L5.D1_lnVA_QI_LO"
	local aggN		"D1_lnVA_LO L.D1_lnVA_LO L2.D1_lnVA_LO L3.D1_lnVA_LO L4.D1_lnVA_LO L5.D1_lnVA_LO"
	
	*Set FE
	local controls "i.sectorgroup i.country*i.bcycle i.country*year i.year"	
	
	**Estimate industry-level impacts		
	*Estimate Table 9, emp
	xi:reg D1_lnEMP `own' `sup' `cus' `controls' [w=weight_c], clus(ic) 
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				gen bE_own =r(estimate)
			lincom D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				gen bE_sup =r(estimate)
			lincom D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				gen bE_cus =r(estimate)
	
	*Estimate Table 9, hrs
	xi:reg D1_lnH_EMP `own' `sup' `cus' `controls' [w=weight_h_c], clus(ic)
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				gen bH_own =r(estimate)
			lincom D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				gen bH_sup =r(estimate)
			lincom D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				gen bH_cus =r(estimate)
				
	*Estimate Table 9, wagebill
	xi:reg D1_lnLAB `own' `sup' `cus' `controls' [w=weight_h_c], clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				gen bHW_own =r(estimate)
			lincom D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				gen bHW_sup =r(estimate)
			lincom D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				gen bHW_cus =r(estimate)
				
	*Estimate Table 9, nominal value added
	xi:reg D1_lnVA `own' `sup' `cus' `controls'  [w=weight_VA_c], clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				gen bYn_own =r(estimate)
			lincom D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				gen bYn_sup =r(estimate)
			lincom D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				gen bYn_cus =r(estimate)
			
	*Estimate Table 9, real value added
	xi:reg D1_lnVA_QI `own' `sup' `cus' `controls'  [w=weight_VA_c], clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				gen bYr_own =r(estimate)
			lincom D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				gen bYr_sup =r(estimate)
			lincom D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				gen bYr_cus =r(estimate)
			
	*Estimate Table 9, laborshare
	xi:reg D1_lnlaborshare `own' `sup' `cus' `controls'  [w=weight_VA_c], clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				gen bLS_own =r(estimate)
			lincom D1_LP1_EMP_net_sup + L.D1_LP1_EMP_net_sup + L2.D1_LP1_EMP_net_sup + L3.D1_LP1_EMP_net_sup + L4.D1_LP1_EMP_net_sup + L5.D1_LP1_EMP_net_sup
				gen bLS_sup =r(estimate)
			lincom D1_LP1_EMP_net_cus + L.D1_LP1_EMP_net_cus + L2.D1_LP1_EMP_net_cus + L3.D1_LP1_EMP_net_cus + L4.D1_LP1_EMP_net_cus + L5.D1_LP1_EMP_net_cus
				gen bLS_cus =r(estimate)
	
	**Estimate aggregate impacts
	local controls "i.sectorgroup"

	*Employment
	xi:reg D1_lnEMP `aggR' `controls' [w=weight_c], clus(ic) 
			lincom D1_lnVA_QI_LO + L.D1_lnVA_QI_LO + L2.D1_lnVA_QI_LO + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO + L5.D1_lnVA_QI_LO
				gen bE_agg =r(estimate)
	
	*Hrs
	xi:reg D1_lnH_EMP `aggR'  `controls' [w=weight_h_c], clus(ic)
			lincom D1_lnVA_QI_LO + L.D1_lnVA_QI_LO + L2.D1_lnVA_QI_LO + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO + L5.D1_lnVA_QI_LO
				gen bH_agg =r(estimate)
				
	*Wagebill
	xi:reg D1_lnLAB `aggN' `controls' [w=weight_h_c], clus(ic) 
			lincom D1_lnVA_LO + L.D1_lnVA_LO + L2.D1_lnVA_LO + L3.D1_lnVA_LO + L4.D1_lnVA_LO + L5.D1_lnVA_LO
				gen bHW_agg =r(estimate)
		
	*Nominal value added
	xi:reg D1_lnVA `aggN' `controls' [w=weight_VA_c], clus(ic)
			lincom D1_lnVA_LO + L.D1_lnVA_LO + L2.D1_lnVA_LO + L3.D1_lnVA_LO + L4.D1_lnVA_LO + L5.D1_lnVA_LO
				gen bYn_agg =r(estimate)
	
	*Real value added
	xi:reg D1_lnVA_QI `aggR' `controls' [w=weight_VA_c], clus(ic)
			lincom D1_lnVA_QI_LO + L.D1_lnVA_QI_LO + L2.D1_lnVA_QI_LO + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO + L5.D1_lnVA_QI_LO
				gen bYr_agg =r(estimate)

	*Laborshare
	xi:reg D1_lnlaborshare `aggN' `controls' [w=weight_VA_c], clus(ic)
			lincom D1_lnVA_LO + L.D1_lnVA_LO + L2.D1_lnVA_LO + L3.D1_lnVA_LO + L4.D1_lnVA_LO + L5.D1_lnVA_LO
				gen bLS_agg =r(estimate)
				
		*Calculate time-averaged share of each industry's nominal value added in national income
		gen temp=VA/VA_TOT
		bysort country industry: egen VAshare=mean(temp)
		bysort country year: egen test=sum(VAshare)	/*note: not 1 since we exclude some industries, together making up around 10% of total VA*/
		drop temp test 

	keep country code code_hier sectorgroup year weight* b*_own* b*_cus* b*_sup* b*_agg* VAshare D1_LP1_EMP D1_LP1_EMP_net_sup D1_LP1_EMP_net_cus D1_lnVA_QI_TOT D1_lnVA_P_TOT
save $path_temp\temp2, replace


**3. Predicting own, supplier, customer effects for all outcomes, aggregating across industries
	foreach var in E H HW LS Yr Yn {
	use $path_temp\temp2, clear

		*Own effect
		gen D`var'_own = 	b`var'_own * D1_LP1_EMP
		label var D`var'_own "Country-industry-year `var' change (in log points) from productivity growth in own industry"
			bysort country year (D`var'_own) : gen allmissing_own = mi(D`var'_own[1])

		*Spillover effect from up- & downstream
		gen D`var'_sup = 	b`var'_sup * D1_LP1_EMP_net_sup
		gen D`var'_cus= 	b`var'_cus * D1_LP1_EMP_net_cus
		label var D`var'_sup "Country-industry-year `var' change (in log points) from productivity growth in supplier industries"	
		label var D`var'_cus "Country-industry-year `var' change (in log points) from productivity growth in customer industries"	
			bysort country year (D`var'_sup) : gen allmissing_sup = mi(D`var'_sup[1])
			bysort country year (D`var'_cus) : gen allmissing_cus = mi(D`var'_cus[1])

		save $path_temp\temp_`var', replace
	}

	*Predicting industry-level output effects (own, supplier, customer) 
	foreach var in Yr Yn {
	use $path_temp\temp2, clear

		*Own effect
		gen D`var'_own = 	b`var'_own * D1_LP1_EMP
		label var D`var'_own "Country-industry-year `var' change (in log points) from productivity growth in own industry"
			bysort country year (D`var'_own) : gen allmissing_own = mi(D`var'_own[1])

		*Spillover effect from up- & downstream
		gen D`var'_sup = 	b`var'_sup * D1_LP1_EMP_net_sup
		gen D`var'_cus= 	b`var'_cus * D1_LP1_EMP_net_cus
		label var D`var'_sup "Country-industry-year `var' change (in log points) from productivity growth in supplier industries"	
		label var D`var'_cus "Country-industry-year `var' change (in log points) from productivity growth in customer industries"	
			bysort country year (D`var'_sup) : gen allmissing_sup = mi(D`var'_sup[1])
			bysort country year (D`var'_cus) : gen allmissing_cus = mi(D`var'_cus[1])

		keep country code code_hier year D`var'_own D`var'_sup D`var'_cus b*_agg* VAshare 
		
		foreach i in own sup cus {
			gen D1_lnVAict_hat_`i' = D`var'_`i'  * VAshare
			bysort country year: egen D1_lnVAct_hat_`i'_LO  = sum(D1_lnVAict_hat_`i') if D1_lnVAict_hat_`i'!=.
		}
		keep country code code_hier year D1_lnVAct_hat_own_LO D1_lnVAct_hat_sup_LO D1_lnVAct_hat_cus_LO
		drop if D1_lnVAct_hat_cus_LO==.
		duplicates drop country year, force
		drop code
		
		save $path_temp\temp_ind_`var', replace
	}
	
	*Predicting final demand  effects (from own, supplier, customer) for emp, hrs, real output
	foreach var in E H Yr {
	use $path_temp\temp2, clear

	merge m:1 country year using $path_temp\temp_ind_Yr
	keep if _==3
	drop _
	
	gen D`var'_ownagg = D1_lnVAct_hat_own_LO * b`var'_agg
	gen D`var'_supagg = D1_lnVAct_hat_sup_LO * b`var'_agg
	gen D`var'_cusagg = D1_lnVAct_hat_cus_LO * b`var'_agg

	save $path_temp\temp_fd_`var', replace
	}		
			
	*Predicting final demand  effects (from own, supplier, customer) for wagebill, nominal output
	foreach var in HW Yn LS {
	use $path_temp\temp2, clear

	merge m:1 country year using $path_temp\temp_ind_Yn
	keep if _==3
	drop _
	
	gen D`var'_ownagg = D1_lnVAct_hat_own_LO * b`var'_agg
	gen D`var'_supagg = D1_lnVAct_hat_sup_LO * b`var'_agg
	gen D`var'_cusagg = D1_lnVAct_hat_cus_LO * b`var'_agg

	save $path_temp\temp_fd_`var', replace
	}
			
	use $path_temp\temp_E, clear
	merge 1:1 country code year using $path_temp\temp_fd_E
		drop _
	merge 1:1 country code year using $path_temp\temp_H 
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_H
		drop _
	merge 1:1 country code year using $path_temp\temp_HW
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_HW
		drop _
	merge 1:1 country code year using $path_temp\temp_Yn 
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_Yn
		drop _		
	merge 1:1 country code year using $path_temp\temp_Yr 
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_Yr
		drop _		
	merge 1:1 country code year using $path_temp\temp_LS
		drop _	
	merge 1:1 country code year using $path_temp\temp_fd_LS
		drop _	
	keep country code code_hier sector year DE* DH* DY* DLS* weight*
	
	
	foreach var in E H HW Yn Yr LS {
		gen D`var'_agg = D`var'_ownagg + D`var'_cusagg + D`var'_supagg 
			label var D`var'_agg "Country-industry-year `var' change (in log points) from final demand"
		gen D`var'_net = D`var'_own + D`var'_cus + D`var'_sup + D`var'_agg
			label var D`var'_net "Country-industry-year net `var' change (in log points)"
	}	
	
	drop *ownagg *supagg *cusagg

	gen 	decade=1970 if year<=1980
	replace decade=1980 if year>1980&year<=1990
	replace decade=1990 if year>1990&year<=2000
	replace decade=2000 if year>2000
	
order country code sector year decade DE* DH* DY* DLS*
	
save $path_out\Table9_predictions_within, replace	
	
cap log close

*erase temporary files
	cap erase $path_temp\temp_TFPwide.dta
	cap erase $path_temp\temp1.dta
	cap erase $path_temp\temp2.dta
	foreach var in E H HW LS Yr Yn {
		cap erase $path_temp\temp_`var'.dta
		cap erase $path_temp\temp_fd_`var'.dta
		cap erase $path_temp\temp_ind_`var'.dta
	}
